<?php
// STATIC CLASS MANAGING USER PRIVATE PAGE UPDATE NOTIFIER

class pcma_uppu_notifier {
    

    // register button as metabox
    public static function register_btn() {
        global $post, $pc_users;
        
        
        // be sure user has got the e-mail
        $args = array(
            'limit'     => 1,
            'to_get'    => array('id', 'email'),
            'search'    => array(
                array(
                    array('key' => 'page_id', 'operator' => '=', 'val' => $post->ID),
                    array('key' => 'email', 'operator' => '!=', 'val' => ''),
                )
            )
        );
        
        $users = $pc_users->get_users($args);
        if(empty($users) || empty(get_option('pcma_uppu_mail_txt'))) {
            return false;        
        }
        
        $GLOBALS['pcma_uppu_uid'] = array_values($users)[0]['id']; 
        add_meta_box('pcma_uppu_notif', __('Updated contents notification', PCMA_ML), 'pcma_uppu_notifier::btn_code', 'pg_user_page', 'side', 'low');
    }
    
    
    
    // show button
    public static function btn_code() {
        global $post, $pcma_uppu_uid;
        $post_id = $post->ID;
        ?>

        <div id="pcma_uppu_notif_btn_wrap">
            <button type="button" id="pcma_uppu_notif_btn" class="button-primary">
                <i class="dashicons dashicons-bell"></i>
                <span><?php esc_html_e('Notify user', PCMA_ML) ?></span>
            </button>

            <div class="pc_displaynone">
                <div class="pc_spinner pc_spinner_inline"></div>
            </div>    
        </div>
            

        <script type="text/javascript">
        (function($) { 
            "use strict"; 

            let is_acting = false;
            
            
            $(document).on('click', '#pcma_uppu_notif_btn', function() {
                const $wrap = $('#pcma_uppu_notif_btn_wrap'),
                      $spinner_wrap = $wrap.find('> div');
                
                if(is_acting || !confirm("<?php esc_attr_e('Do you really want to notify the user about contents update?', PCMA_ML) ?>")) {
                    return false;    
                }
                
                is_acting = true;
                $spinner_wrap.removeClass('pc_displaynone');
                
                
                let data = {
                    action	: 'pcma_send_uppu_notif',
                    uid     : <?php echo $pcma_uppu_uid ?>,
                    nonce	: "<?php echo wp_create_nonce('lcwp_ajax') ?>"
                };
                $.post(ajaxurl, data, function(response) {
                    if(response.trim() == 'success') {
                        lc_wp_popup_message('success', "<?php esc_attr_e('E-mail sent successfully!', PCMA_ML) ?>");
                    }
                    else {
                        lc_wp_popup_message('error', respose);
                    }
                })
                .fail(function(e) {
                    if(e.status) {
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_html_e('Error performing the action', PCMA_ML) ?>");
                    }
                })
                .always(function() {
                    is_acting = true;
                    $spinner_wrap.addClass('pc_displaynone');
                });
            });
            
        })(jQuery); 
        </script>
        <?php
    }
    

}



add_action('add_meta_boxes', 'pcma_uppu_notifier::register_btn'); // register sending button as meta box
